/*
 * TabWidget.cpp
 *
 *  Created on: 02.08.2011
 *      Author: stefan.detter
 */

#include "TabWidget.h"

#include <License.h>

TabWidget::TabWidget( const QString& name, QWidget * parent )
	: QWidget(parent)
	, m_name(name)
	, m_working(false)
{

}

TabWidget::~TabWidget()
{
}

const QString& TabWidget::name()
{
	return m_name;
}

bool TabWidget::isWorking()
{
	return m_working;
}

void TabWidget::clearView()
{
	return;
}

void TabWidget::setWorking()
{
	m_working = true;
	emit working();
}

void TabWidget::setIdle()
{
	m_working = false;
	emit idle();
}


bool TabWidget::hasExecutionCount()
{
	return false;
}

uint TabWidget::executionCount()
{
	if(hasExecutionCount())
		return License::d->remainingExecutionCount(this);
	else
		return 0;
}

